<?php
@session_start();
include('../includes/session.php');  // Admin session check
include('../includes/config.php');
include('../template/tngweb/header.php'); // Admin header

$status_result = null;
$ticket_number = '';

if(isset($_POST['check_status']) || isset($_GET['ticket'])) {
    $ticket_number = isset($_GET['ticket']) ? $_GET['ticket'] : $_POST['ticket_number'];
    $status_result = getTicketStatus($ticket_number);
}
?>

<div class="content-wrap">
    <div class="main">
        <div class="page-wrapper">
            <div class="page-content">
                <div class="mobile-menu-overlay"></div>
                <div class="main-container">
                    <div class="col-lg-12">
                        <div class="card p-3" style="margin-left: 10px; box-shadow: 1px 5px 5px 5px;">
                            <div class="stat-widget-two">
                                <div class="stat-content">
                                    <div class="stat-text">
                                        <div class="container-fluid">
                                            <div class="row justify-content-center">
                                                <div class="col-lg-6 col-md-8">
                                                    <div class="card">
                                                        <div class="card-body">
                                                            <h3 class="mb-3">Check Ticket Status</h3>
                                                            <p>Enter your ticket number to check the response status.</p>

                                                            <form method="POST" action="">
                                                                <div class="form-group mb-3">
                                                                    <input type="text" name="ticket_number" class="form-control" 
                                                                           placeholder="Enter ticket number e.g., TNG202312011234" 
                                                                           value="<?php echo htmlspecialchars($ticket_number); ?>" required>
                                                                </div>
                                                                <div class="text-end">
                                                                    <button type="submit" name="check_status" class="btn btn-primary">
                                                                        <i class='bx bx-search'></i> Check Status
                                                                    </button>
                                                                </div>
                                                            </form>

                                                            <?php if(isset($_POST['check_status']) || isset($_GET['ticket'])): ?>
                                                                <?php if($status_result): ?>
                                                                    <div class="ticket-details mt-4">
                                                                        <h4 style="color: var(--primary);">Ticket Details</h4>
                                                                        <div class="detail-row"><strong>Ticket Number:</strong> <?php echo $status_result['ticket_number']; ?></div>
                                                                        <div class="detail-row"><strong>Status:</strong> 
                                                                            <span class="status-badge status-<?php echo $status_result['status']; ?>">
                                                                                <?php echo ucfirst($status_result['status']); ?>
                                                                            </span>
                                                                        </div>
                                                                        <div class="detail-row"><strong>Submitted On:</strong> <?php echo date('M j, Y g:i A', strtotime($status_result['created_at'])); ?></div>
                                                                        <div class="detail-row"><strong>Name:</strong> <?php echo htmlspecialchars($status_result['name']); ?></div>
                                                                        <div class="detail-row"><strong>Email:</strong> <?php echo htmlspecialchars($status_result['email']); ?></div>
                                                                        <div class="detail-row"><strong>Message:</strong><br><?php echo nl2br(htmlspecialchars($status_result['message'])); ?></div>
                                                                    </div>

                                                                    <?php if($status_result['reply_message']): ?>
                                                                        <div class="reply-section mt-4">
                                                                            <h5 style="color: var(--primary);"><i class='bx bx-message-check'></i> Admin Response</h5>
                                                                            <p><?php echo nl2br(htmlspecialchars($status_result['reply_message'])); ?></p>
                                                                            <div class="text-muted">
                                                                                <small>Replied by: <?php echo $status_result['replied_by']; ?> on <?php echo date('M j, Y g:i A', strtotime($status_result['replied_at'])); ?></small>
                                                                            </div>
                                                                        </div>
                                                                    <?php else: ?>
                                                                        <div class="no-reply mt-3">
                                                                            <i class='bx bx-time'></i>
                                                                            <p>Your query is being processed. Our team will respond soon.</p>
                                                                        </div>
                                                                    <?php endif; ?>

                                                                <?php else: ?>
                                                                    <div class="no-reply mt-3">
                                                                        <i class='bx bx-error'></i>
                                                                        <p>No ticket found with the provided ticket number. Please check and try again.</p>
                                                                    </div>
                                                                <?php endif; ?>
                                                            <?php endif; ?>

                                                        </div>
                                                    </div>
                                                </div> <!-- col -->
                                            </div> <!-- row -->
                                        </div> <!-- container -->
                                    </div>
                                </div>
                            </div>
                        </div>
                        <br><br>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include('../template/tngweb/footer.php'); ?>

<script src="../template/tngweb/assets/js/bootstrap.bundle.min.js"></script>
<script src="../template/tngweb/assets/plugins/simplebar/js/simplebar.min.js"></script>
<script src="../template/tngweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
<script src="../template/tngweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
<script src="../template/tngweb/assets/js/app.js"></script>
