<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/tngweb/header.php');

if ($udata['id'] != '1' || $udata['type'] != 'admin') {
    echo '<script>
alert("Access Denied! Only Admin can view this page.");
window.location.href = "../includes/logout.php";
</script>';
    exit;
}

$result = mysqli_query($tng_conn, "SELECT * FROM `users` ORDER BY id ASC LIMIT 1");
$defaultData = mysqli_fetch_assoc($result) ?: [];


if (isset($_POST['siteupdate'])) {
    $result = saveUserSettings($_POST, $fields, $fee_fields, $status_only_fields);
    ?>
    <script src='https://cdn.jsdelivr.net/npm/sweetalert2@11'></script>
    <script>
        Swal.fire({
            icon: '<?php echo $result['success'] ? "success" : "error"; ?>',
            title: '<?php echo $result['success'] ? "Success!" : "Update Failed!"; ?>',
            text: '<?php echo $result['message']; ?>',
            confirmButtonText: 'OK'
        }).then((res) => {
            if (res.isConfirmed && <?php echo $result['success'] ? "true" : "false"; ?>) {
                window.location.href = 'Services_Manage.php';
            }
        });
    </script>
    <?php
}
?>


<!--start page wrapper -->
<div class="page-wrapper">
  <div class="page-content">
    <div class="card radius-15 shadow-lg border-0">
      <div class="card-body">
        <!-- Back Button -->
        <div class="d-flex align-items-center justify-content-between mb-3">
          <a href="javascript:void(0);" onclick="window.history.back();" class="btn btn-outline-primary rounded-pill px-4 py-2 fw-semibold">
            <i class="bi bi-arrow-left-circle me-2"></i> Go Back
          </a>
           <h4 class="mb-3">Update Services & Fees for All Users</h4>
        </div>


        <form method="POST" action="">
          <div class="container">

            <!-- Service ON/OFF -->
            <h6 class="mb-2">Service ON/OFF</h6>
            <div class="row">
              <?php foreach($fields as $field): ?>
                <div class="col-md-3 mb-2">
                  <label style="
    color: #ff4d4f;          /* Bright Red */
    font-weight: 700;         /* Bold */
    font-size: 15px;          /* Thoda bada */
    text-shadow: 1px 1px 2px rgba(0,0,0,0.2); /* Soft shadow */
    margin-bottom: 6px;
    display: block;
">
    <?= ucwords(str_replace('_',' ',$field)) ?>
</label>

                  <select name="<?=$field?>" class="form-control">
                    <option value="on" <?= ($defaultData[$field] ?? '') === 'on' ? 'selected' : '' ?>>ON</option>
                    <option value="off" <?= ($defaultData[$field] ?? '') === 'off' ? 'selected' : '' ?>>OFF</option>
                  </select>
                </div>
              <?php endforeach; ?>
            </div>

            <hr>

            <!-- Service Fees -->
            <h6 class="mb-2">Service Fees</h6>
            <div class="row">
              <?php foreach($fee_fields as $field): ?>
                <div class="col-md-3 mb-2">
                 <label style="
    color: #007bff;          /* Royal Blue */
    font-weight: 600;         /* Semi-bold */
    font-size: 15px;
    text-shadow: 0 0 3px rgba(0,123,255,0.5); /* Glow effect */
    margin-bottom: 6px;
    display: block;
">
    <?= ucwords(str_replace('_',' ',$field)) ?>
</label>

                  <input type="number" name="<?=$field?>" class="form-control" value="<?=$defaultData[$field] ?? '0'?>" required>
                </div>
              <?php endforeach; ?>
            </div>

<!-- Status Only -->
            <h6 class="mb-2">Status Only Services</h6>
            <div class="row">
              <?php foreach($status_only_fields as $field): ?>
                <div class="col-md-3 mb-2">
                  <label style="
    color: #28a745;          /* Emerald Green */
    font-weight: 600;
    font-size: 15px;
    text-shadow: 0 0 2px rgba(40,167,69,0.4); /* Soft glow */
    margin-bottom: 6px;
    display: block;
">
    <?= ucwords(str_replace('_',' ',$field)) ?>
</label>

                  <select name="<?=$field?>" class="form-control">
                    <option value="on" <?= ($defaultData[$field] ?? '') === 'on' ? 'selected' : '' ?>>ON</option>
                    <option value="off" <?= ($defaultData[$field] ?? '') === 'off' ? 'selected' : '' ?>>OFF</option>
                  </select>
                </div>
              <?php endforeach; ?>
            </div>
            <div class="text-center mt-3">
              <button type="submit" name="siteupdate" class="btn btn-success">Update All Members</button>
            </div>

          </div>
        </form>
      </div>
    </div>
  </div>
</div>

<?php include('../template/tngweb/footer.php'); ?>

<!-- ✅ DataTables CDN & Scripts -->
<script src="../template/tngweb/assets/plugins/simplebar/js/simplebar.min.js"></script>
<script src="../template/tngweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
<script src="../template/tngweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
<script src="../template/tngweb/assets/js/app.js"></script>


<script>
  $(document).ready(function() {
    $('#walletTable').DataTable({
      lengthChange: false,
      pageLength: 10,
      order: [[0, "desc"]],
      buttons: ['copy', 'excel', 'pdf', 'print'],
      dom: '<"d-flex justify-content-between align-items-center mb-3"Bf>rt<"d-flex justify-content-between align-items-center"ip>'
    });
  });
</script>

<style>
  /* 🌟 Stylish Table */
  .table thead th {
    vertical-align: middle;
    font-weight: 600;
    letter-spacing: 0.3px;
  }

  .table tbody tr:hover {
    background: #f5f8ff;
    transition: 0.2s ease;
  }

  .card {
    background: #fff;
    border-radius: 15px;
  }

  .btn-outline-primary {
    border-color: #0055ff;
    color: #0055ff;
  }

  .btn-outline-primary:hover {
    background-color: #0055ff;
    color: #fff;
  }

  .dataTables_wrapper .dataTables_filter input {
    border-radius: 8px;
    padding: 5px 10px;
  }

  .dataTables_wrapper .dataTables_paginate .paginate_button {
    border-radius: 5px;
  }

  .dataTables_wrapper .dt-buttons .btn {
    border-radius: 20px !important;
    font-size: 0.85rem;
    margin-right: 6px;
  }

  .badge {
    font-size: 0.8rem;
    padding: 6px 10px;
  }
</style>
