<?php
$operators_json = '[
    {"OperatorID":1,"OperatorName":"Airtel","Commission":"1.5"},
    {"OperatorID":2,"OperatorName":"Idea","Commission":"3"},
    {"OperatorID":3,"OperatorName":"Vodafone","Commission":"3"},
    {"OperatorID":4,"OperatorName":"Jio","Commission":"1.2"},
    {"OperatorID":5,"OperatorName":"Bsnl Special","Commission":"3.5"},
    {"OperatorID":6,"OperatorName":"Bsnl Topup","Commission":"3.5"},
    {"OperatorID":7,"OperatorName":"Airtel Digital TV","Commission":"3"},
    {"OperatorID":8,"OperatorName":"Dish TV","Commission":"3"},
    {"OperatorID":9,"OperatorName":"Sun Direct","Commission":"2"},
    {"OperatorID":10,"OperatorName":"Tata Sky","Commission":"3"},
    {"OperatorID":11,"OperatorName":"Videocon D2H","Commission":"3"},
    {"OperatorID":12,"OperatorName":"Google Play Recharge","Commission":"1"}
]';

$operators = json_decode($operators_json, true);

// Build HTML table
$table = '<table border="1" style="width:100%;text-align:left;border-collapse:collapse">';
$table .= '<tr><th>ID</th><th>Operator</th><th>Commission (%)</th></tr>';
foreach($operators as $op){
    $table .= '<tr>';
    $table .= '<td>'.$op['OperatorID'].'</td>';
    $table .= '<td>'.$op['OperatorName'].'</td>';
    $table .= '<td>'.$op['Commission'].'</td>';
    $table .= '</tr>';
}
$table .= '</table>';
?>

<!-- Button -->
<button id="viewCommissionBtn" style="padding:10px 20px;font-size:16px;cursor:pointer;">
    View Commissions
</button>

<!-- SweetAlert2 -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
document.getElementById('viewCommissionBtn').addEventListener('click', function() {
    Swal.fire({
        title: 'Operators Commission',
        html: `<?php echo $table; ?>`,
        width: '600px',
        confirmButtonText: 'Close'
    });
});
</script>
