<?php
include('../includes/session.php');
include('../includes/config.php');
if ($udata['id'] != '1' || $udata['type'] != 'admin') {
    echo '<script>
        alert("Access Denied! Only Admin can view this page.");
        window.location.href = "../includes/logout.php";
    </script>';
    exit;
}
$data = balance_info_api_run($request);

?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Balance & History</title>

  <!-- DataTables CSS -->
  <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">

  <style>
    body {
      font-family: "Segoe UI", Arial, sans-serif;
      background: #0b0f17;
      color: #e5e7eb;
      margin: 0;
      padding: 20px;
    }
    h1 {
      margin-bottom: 20px;
      color: #fff;
      text-align: center;
      font-size: 26px;
      letter-spacing: 1px;
    }
    .summary {
      display: flex;
      gap: 20px;
      margin-bottom: 30px;
      flex-wrap: wrap;
      justify-content: center;
    }
    .card {
      padding: 15px 25px;
      background: linear-gradient(145deg, #111827, #1f2937);
      border-radius: 15px;
      box-shadow: 0 6px 15px rgba(0,0,0,.4);
      text-align: center;
      transition: transform .2s ease;
    }
    .card:hover { transform: translateY(-4px); }
    .card span {
      display: block;
      font-size: 12px;
      color: #94a3b8;
      margin-bottom: 4px;
    }
    .card strong {
      font-size: 20px;
      color: #60a5fa;
    }
    /* DataTable Styling */
    table.dataTable {
      background: #111827;
      color: #fff;
      border-radius: 12px;
      overflow: hidden;
      box-shadow: 0 4px 10px rgba(0,0,0,.4);
    }
    table.dataTable thead {
      background: #1e293b;
      color: #94a3b8;
      font-size: 14px;
    }
    table.dataTable tbody tr:hover {
      background: rgba(59,130,246,.15);
      transition: background 0.3s;
    }
    .dataTables_wrapper .dataTables_filter input {
      border-radius: 8px;
      padding: 6px 10px;
      border: 1px solid #374151;
      background: #1f2937;
      color: #fff;
    }
    .dataTables_wrapper .dataTables_paginate .paginate_button {
      border-radius: 6px;
      margin: 2px;
      padding: 4px 10px;
      background: #1f2937;
      border: none;
      color: #fff !important;
    }
    .dataTables_wrapper .dataTables_paginate .paginate_button.current {
      background: #3b82f6 !important;
      color: white !important;
    }
  </style>
</head>
<body>
<div class="mb-4">
        <a href="javascript:history.back()" class="back-btn">
            <i class="bi bi-arrow-left-circle"></i> Go Back
        </a>
    </div>
<h1>🚀 Api Balance Info</h1>

<?php if ($data && $data['status']=="success"): ?>
  <div class="summary">
    <div class="card"><span>Name</span><strong><?= htmlspecialchars($data['name']) ?></strong></div>
    <div class="card"><span>Wallet</span><strong>₹<?= htmlspecialchars($data['wallet']) ?></strong></div>
    <div class="card"><span>Total Count</span><strong><?= htmlspecialchars($data['total_count']) ?></strong></div>
    <div class="card"><span>Updated</span><strong><?= date("Y-m-d H:i:s") ?></strong></div>
  </div>

  <table id="historyTable" class="display nowrap" style="width:100%">
    <thead>
      <tr>
          <th>Sl</th>
       
        <th>API Name</th>
        <th>Charge</th>
        <th>New Balance</th>
        <th>Order id</th>
         <th>Date</th>
      </tr>
    </thead>
    <tbody>
<?php foreach (($data['data'] ?? []) as $row): ?>
  <tr>
      <td><?= (int)($row['sl'] ?? 0) ?></td>

  

    <td><?= htmlspecialchars($row['txn_type'] ?? '') ?></td>

    <td>
      ₹<?= htmlspecialchars(number_format((float)($row['txn_amount'] ?? 0), 2)) ?>
      <br>
      <small class="<?= (($row['type'] ?? '') === 'debit') ? 'text-danger' : 'text-success' ?>">
        <?= htmlspecialchars(strtoupper($row['type'] ?? '')) ?>
      </small>
    </td>

    <td>₹<?= htmlspecialchars(number_format((float)($row['closing_balance'] ?? 0), 2)) ?></td>

    <td><?= htmlspecialchars($row['order_id'] ?? '') ?></td>
    
      <td>
      <?= htmlspecialchars($row['date'] ?? '') ?>
      <?php if (!empty($row['time'])): ?>
        <br><small><?= htmlspecialchars($row['time']) ?></small>
      <?php endif; ?>
    </td>
  </tr>
<?php endforeach; ?>

<?php if (empty($data['data'])): ?>
  <tr>
    <td colspan="5" class="text-center">No transactions found</td>
  </tr>
<?php endif; ?>

    </tbody>
  </table>
<?php else: ?>
  <p style="color:#f87171;text-align:center;">⚠️ Failed to load API data.</p>
<?php endif; ?>

<!-- jQuery + DataTables -->
<script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<script>
$(document).ready(function() {
    $('#historyTable').DataTable({
        pageLength: 10,
        responsive: true,
        language: {
            search: "🔍 Search:",
            lengthMenu: "Show _MENU_ entries",
            info: "Showing _START_ to _END_ of _TOTAL_ entries"
        }
    });
});
</script>
<?php include('../template/tngweb/footer.php'); ?>
</body>
</html>