<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/tngweb/header.php');

if ($udata['id'] != '1' || $udata['type'] != 'admin') {
    echo '<script>
        Swal.fire({
            icon: "error",
            title: "Access Denied!",
            text: "Only Admin can view this page."
        }).then(() => window.location.href="../includes/logout.php");
    </script>';
    exit;
}


$site_data = fetchSiteData($tng_conn);


if (isset($_POST['siteupdate'])) {
    if (updateSiteSettings($tng_conn, $_POST)) {
        swal("✅ Site Updated Successfully!", "success", $_SERVER['PHP_SELF']);
        exit;
    } else {
        swal("❌ Site Update Error!", "error");
    }
}

if (isset($_POST['logoupdate']) && isset($_FILES['logo']['name'])) {
    $res = updateSiteLogo($tng_conn, $_FILES['logo']);
    if ($res['status']) {
        swal($res['msg'], "success", $_SERVER['PHP_SELF']);
        exit;
    } else {
        swal($res['msg'], "error");
    }
}
?>

<!--start page wrapper -->
<div class="page-wrapper">
  <div class="page-content">
    <div class="card radius-15 shadow-lg border-0">
      <div class="card-body">
        <!-- Back Button -->
        <div class="d-flex align-items-center justify-content-between mb-3">
          <a href="javascript:void(0);" onclick="window.history.back();" class="btn btn-outline-primary rounded-pill px-4 py-2 fw-semibold">
            <i class="bi bi-arrow-left-circle me-2"></i> Go Back
          </a>
         <h4 class="mb-3 text-info">⚙️ Update Services & Fees for All Users</h4>
        </div>

       
         
        <form class="row" method="POST" action="">
          <div class="col-md-4 mb-3">
            <label>Brand</label>
            <input type="text" class="form-control" name="brand" value="<?= htmlspecialchars($site_data['brand']) ?>" required>
          </div>
          <div class="col-md-4 mb-3">
            <label>Title</label>
            <input type="text" class="form-control" name="title" value="<?= htmlspecialchars($site_data['title']) ?>" required>
          </div>
          <div class="col-md-4 mb-3">
            <label>Mobile Number</label>
            <input type="number" class="form-control" name="mobile" onkeypress="if(this.value.length==10) return false;" value="<?= htmlspecialchars($site_data['phone']) ?>" required>
          </div>
          <div class="col-md-4 mb-3">
            <label>Telegram Username</label>
            <input type="text" class="form-control" name="telegram_username" value="<?= htmlspecialchars($site_data['telegram_username']) ?>" required>
          </div>
          <div class="col-md-4 mb-3">
            <label>Email Address</label>
            <input type="text" class="form-control" name="email" value="<?= htmlspecialchars($site_data['email']) ?>" required>
          </div>
          <div class="col-md-4 mb-3">
            <label>Address</label>
            <input type="text" class="form-control" name="address" value="<?= htmlspecialchars($site_data['address']) ?>" required>
          </div>
          <div class="col-md-4 mb-3">
            <label>Protocol & Domain</label>
            <div class="input-group">
              <select name="protocol" class="form-select" style="max-width:100px;">
                <option <?= $site_data['protocol']=="http://" ? 'selected':'' ?> value="http://">http://</option>
                <option <?= $site_data['protocol']=="https://" ? 'selected':'' ?> value="https://">https://</option>
              </select>
              <input type="text" class="form-control" name="baseurl" value="<?= htmlspecialchars($site_data['baseurl']) ?>" required>
            </div>
          </div>
          <div class="col-md-3 mb-3">
            <label>Otp System On/Off</label>
            <select class="form-select" name="self_registertion" required>
                <option value="yes" <?= $site_data['otp_option'] === 'yes' ? 'selected' : '' ?>>Active</option>
                <option value="no" <?= $site_data['otp_option'] === 'no' ? 'selected' : '' ?>>Deactive</option>
            </select>
          </div>
          
          <div class="col-md-3 mb-3">
            <label>Register Payment Staus</label>
            <select class="form-select" name="payment_status" required>
                <option value="1" <?= $site_data['payment_status'] === '1' ? 'selected' : '' ?>>✅ No Payment Required – ID will be active immediately</option>
                <option value="0" <?= $site_data['payment_status'] === '0' ? 'selected' : '' ?>>🔒 Payment Required – ID will be active only after payment</option>
            </select>
          </div>
          
          <div class="col-md-3 mb-3">
            <label>Gateway Service</label>
            <select class="form-select" name="gateway_service" required>
                <option value="active" <?= $site_data['gateway'] === 'active' ? 'selected' : '' ?>>Active</option>
                <option value="inactive" <?= $site_data['gateway'] === 'inactive' ? 'selected' : '' ?>>Deactive</option>
            </select>
          </div>
          
          <div class="col-md-3 mb-3">
            <label>Register Page Status</label>
            <select class="form-select" name="register_status" required>
                <option value="active" <?= $site_data['register_status'] === 'active' ? 'selected' : '' ?>>Active</option>
                <option value="inactive" <?= $site_data['register_status'] === 'inactive' ? 'selected' : '' ?>>Deactive</option>
            </select>
          </div>
          <div class="col-md-3 mb-3">
    <label>Support Status</label>
    <select class="form-select" name="support_status" required>
        <option value="default" <?= ($site_data['support_status'] === 'default') ? 'selected' : '' ?>>Default</option>
        <option value="whatsapp" <?= ($site_data['support_status'] === 'whatsapp') ? 'selected' : '' ?>>Whatsapp</option>
        <option value="telegram" <?= ($site_data['support_status'] === 'telegram') ? 'selected' : '' ?>>Telegram</option>
    </select>
</div>

<div class="col-md-3 mb-3">
            <label>Balance Add Minimum  Amount</label>
            <input type="text" class="form-control" name="balance_add_minumum_amount" value="<?= htmlspecialchars($site_data['balance_add_minumum_amount']) ?>" required>
          </div>
          <div class="col-md-3 mb-3">
            <label>Retailer Charge</label>
            <input type="text" class="form-control" name="user_charge" value="<?= htmlspecialchars($site_data['ret_reg_fee']) ?>" required>
          </div>
          <div class="col-md-3 mb-3">
            <label>Distributor Charge</label>
            <input type="text" class="form-control" name="distributor_charge" value="<?= htmlspecialchars($site_data['dist_reg_fee']) ?>" required>
          </div>
          <div class="col-md-12 mb-3">
            <label>Chat Script</label>
            <textarea class="form-control" name="self_script" required><?= htmlspecialchars($site_data['self_script']) ?></textarea>
          </div>
          <div class="col-md-4 mb-3">
            <button type="submit" class="btn btn-primary btn-block" name="siteupdate">Submit</button>
          </div>
        </form>
       </div>
      </div>

      <!-- Brand Logo Section -->
      <div class="card p-4">
       <div class="card-body">
          <h5 class="text-info">🏷️ Brand Logo</h5>
          <form class="row" method="POST" action="" enctype="multipart/form-data">
            <div class="col-md-12 mb-3">
              <label>Logo</label>
              <input type="file" class="form-control" name="logo" required>
            </div>
            <div class="col-md-4 mb-3">
              <button class="btn btn-primary btn-block" name="logoupdate">Upload</button>
            </div>
          </form>
          <?php if (!empty($site_data['logo'])): ?>
            <img src="<?= $site_data['logo'] ?>" class="logo" style="max-width:200px;height:auto;">
          <?php endif; ?>
       </div>
      </div>

     </div>
    </div>
  </div>
 </div>
</div>

         
<!--end page wrapper -->

<?php include('../template/tngweb/footer.php'); ?>

<!-- ✅ DataTables CDN & Scripts -->
<script src="../template/tngweb/assets/plugins/simplebar/js/simplebar.min.js"></script>
<script src="../template/tngweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
<script src="../template/tngweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
<script src="../template/tngweb/assets/js/app.js"></script>


<script>
  $(document).ready(function() {
    $('#walletTable').DataTable({
      lengthChange: false,
      pageLength: 10,
      order: [[0, "desc"]],
      buttons: ['copy', 'excel', 'pdf', 'print'],
      dom: '<"d-flex justify-content-between align-items-center mb-3"Bf>rt<"d-flex justify-content-between align-items-center"ip>'
    });
  });
</script>

<style>
  /* 🌟 Stylish Table */
  .table thead th {
    vertical-align: middle;
    font-weight: 600;
    letter-spacing: 0.3px;
  }

  .table tbody tr:hover {
    background: #f5f8ff;
    transition: 0.2s ease;
  }

  .card {
    background: #fff;
    border-radius: 15px;
  }

  .btn-outline-primary {
    border-color: #0055ff;
    color: #0055ff;
  }

  .btn-outline-primary:hover {
    background-color: #0055ff;
    color: #fff;
  }

  .dataTables_wrapper .dataTables_filter input {
    border-radius: 8px;
    padding: 5px 10px;
  }

  .dataTables_wrapper .dataTables_paginate .paginate_button {
    border-radius: 5px;
  }

  .dataTables_wrapper .dt-buttons .btn {
    border-radius: 20px !important;
    font-size: 0.85rem;
    margin-right: 6px;
  }

  .badge {
    font-size: 0.8rem;
    padding: 6px 10px;
  }
</style>
