<?php
@session_start();
include('includes/config.php');

$alert_script = '';

if(isset($_POST['submit'])) {
    $name = $_POST['name'];
    $email = $_POST['email'];
    $mobile = $_POST['mobile'];
    $message = $_POST['message'];

    $result = submitContactQuery($name, $email, $mobile, $message);

    if($result['success']) {
        $ticket_number = $result['ticket_number'];
        $alert_script = '
            Swal.fire({
                title: "Success! 🎉",
                html: "Your message has been sent successfully!<br><br><strong>Ticket Number:</strong> ' . $ticket_number . '<br><br>We have sent a confirmation to your email.",
                icon: "success",
                confirmButtonColor: "#4bb543"
            }).then(() => {
                document.getElementById("contactForm").reset();
            });
        ';
    } else {
        $alert_script = '
            Swal.fire({
                title: "Error!",
                text: "Failed to send message. Please try again. '.$result['error'].'",
                icon: "error",
                confirmButtonColor: "#dc3545"
            });
        ';
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" href="./template/tngweb/assets/images/favicon-32x32.png" type="image/png" />
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href='https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css' rel='stylesheet'>
     <link href="./template/tngweb/assets/css/contact.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.4.14/dist/sweetalert2.all.min.js"></script>
    <title><?php echo XyZ_val('brand'); ?> | Contact Us</title>
    

</head>

<body>
    <!-- Navigation -->
    <nav class="navbar">
        <div class="nav-container">
            <a href="index.php" class="logo">
                <img src="<?php echo XyZ_val('logo'); ?>" alt="Logo">
                <?php echo XyZ_val('brand'); ?>
            </a>
            
            <ul class="nav-links">
                <li><a href="index.php">Home</a></li>
                <li><a href="register.php">Register</a></li>
                <li><a href="login.php">Login</a></li>
                <li><a href="contact.php" class="active">Contact</a></li>
            </ul>
        </div>
    </nav>

    <!-- Contact Content -->
    <div class="contact-container">
        <div class="contact-card">
            <div class="contact-header">
                <i class='bx bx-envelope contact-icon'></i>
                <h1>Contact Us</h1>
                <p>We'd love to hear from you. Send us a message!</p>
            </div>
            
            <div class="contact-body">
                <form method="POST" action="" id="contactForm">
                    <div class="form-group">
                        <label for="name" class="form-label">Full Name *</label>
                        <input type="text" name="name" class="form-control" id="name" placeholder="Enter your full name" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="email" class="form-label">Email Address *</label>
                        <input type="email" name="email" class="form-control" id="email" placeholder="Enter your email" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="mobile" class="form-label">Mobile Number *</label>
                        <input type="text" name="mobile" class="form-control" id="mobile" placeholder="Enter your mobile number" required maxlength="10">
                    </div>
                    
                    <div class="form-group">
                        <label for="message" class="form-label">Message *</label>
                        <textarea name="message" class="form-control" id="message" placeholder="Enter your message" required></textarea>
                    </div>
                    
                    <button type="submit" name="submit" class="submit-btn">
                        <i class='bx bx-send'></i> Send Message
                    </button>
                    
                    <div class="check-status-link">
                        <a href="check_status.php">Check existing ticket status</a>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <p>&copy; <?php echo date("Y"); ?> <?php echo XyZ_val('brand'); ?>. All rights reserved.</p>
        </div>
    </footer>

    <script>
        // Mobile number validation
        document.getElementById('mobile').addEventListener('input', function(e) {
            this.value = this.value.replace(/[^0-9]/g, '');
        });
        
        // Form validation
        document.getElementById('contactForm').addEventListener('submit', function(e) {
            const name = document.getElementById('name').value.trim();
            const email = document.getElementById('email').value.trim();
            const mobile = document.getElementById('mobile').value.trim();
            const message = document.getElementById('message').value.trim();
            
            if (!name || !email || !mobile || !message) {
                e.preventDefault();
                Swal.fire({
                    title: "Required!",
                    text: "Please fill all required fields",
                    icon: "warning",
                    confirmButtonColor: "#ffc107"
                });
                return;
            }
            
            if (mobile.length !== 10) {
                e.preventDefault();
                Swal.fire({
                    title: "Invalid Mobile!",
                    text: "Please enter a valid 10-digit mobile number",
                    icon: "warning",
                    confirmButtonColor: "#ffc107"
                });
                return;
            }
            
            // Email validation
            const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            if (!emailRegex.test(email)) {
                e.preventDefault();
                Swal.fire({
                    title: "Invalid Email!",
                    text: "Please enter a valid email address",
                    icon: "warning",
                    confirmButtonColor: "#ffc107"
                });
                return;
            }
        });
        
        // Auto focus on first field
        document.addEventListener('DOMContentLoaded', function() {
            document.getElementById('name').focus();
            
            <?php if (!empty($alert_script)): ?>
            <?php echo $alert_script; ?>
            <?php endif; ?>
        });
    </script>
</body>
</html>